/*****************************************************************************
*  LPC154x blinky program for LPCXpresso board
*
*  1. Use SCT3 timer to generate a 100 msec toggle output @ SCT3_OUT0
*  2. SCT3_OUT0 is linked to P0_25 (red LED) and toggles every 100 msec)
*****************************************************************************/

#include "board.h"

/*****************************************************************************
 * Private types/enumerations/variables
 ****************************************************************************/

/*****************************************************************************
 * Public types/enumerations/variables
 ****************************************************************************/

/*****************************************************************************
 * Private functions
 ****************************************************************************/
void SCT3_Init(void);
/*****************************************************************************
 * Public functions
 ****************************************************************************/

void SCT3_Init(void)
{

	Chip_SCT_Init(LPC_SCT3);			                   						          // enable the SCT3 clock

	Chip_SCT_Config(LPC_SCT3, SCT_CONFIG_32BIT_COUNTER); 						      // unified timers

	Chip_SCT_SetMatchCount(LPC_SCT3, SCT_MATCH_0,	(SystemCoreClock/10)-1);				  // match 0 @ 10Hz = 100 msec
	Chip_SCT_SetMatchReload(LPC_SCT3, SCT_MATCH_0, (SystemCoreClock/10)-1);


	Chip_SCT_EventState(LPC_SCT3, SCT_EVENT_0, ENABLE_STATE0);					  // event 0 only happens in state 0
	Chip_SCT_EventControl(LPC_SCT3, SCT_EVENT_0, (CHIP_SCT_EVENTCTRL_T)   ( SCT_EVECTRL_MATCH0		|		// related to match 0
                                                                          SCT_COMBMODE_MATCH		|		// COMBMODE[13:12] = match condition only
                                                                          SCT_STATELD_1			    |		// STATELD[14] = STATEV is loaded into state
                                                                          SCT_STATEEV_1			    ));	// STATEV[15] = 1 (new state is 1)


	Chip_SCT_EventState(LPC_SCT3, SCT_EVENT_1, ENABLE_STATE1);					  // event 1 only happens in state 1
	Chip_SCT_EventControl(LPC_SCT3, SCT_EVENT_1, (CHIP_SCT_EVENTCTRL_T)   ( SCT_EVECTRL_MATCH0		|		// related to match 0
                                                                          SCT_COMBMODE_MATCH		|		// COMBMODE[13:12] = match condition only
                                                                          SCT_STATELD_1			    |		// STATELD[14] = STATEV is loaded into state
                                                                          SCT_STATEEV_0			    ));	// STATEV[15] = 0 (new state is 0)


	Chip_SCT_SetOutput(LPC_SCT3, SCT_OUTPUT_0, SCT_EVT_0);						    // event 0 will set SCT_OUT_0
	Chip_SCT_ClearOutput(LPC_SCT3, SCT_OUTPUT_0, SCT_EVT_1);					    // event 1 will clear SCT_OUT_0

  LPC_SCT3->LIMIT_L           = 0x0003;                  						    // events 0 and 1 are used as counter limit

  Chip_SCT_ClearControl(LPC_SCT3, SCT_CTRL_HALT_L);							        // start timer
}


int main(void)
{
  	SystemCoreClockUpdate();
  	Board_Init();

  	Chip_Clock_EnablePeriphClock(SYSCTL_CLOCK_SWM);						//enable SWM clock

  	Chip_SWM_MovablePortPinAssign(SWM_SCT3_OUT0_O , 0, 25); 			// P0_25 is SCT3_OUT0

    SCT3_Init();                                           				// Initialize SCT3

    while (1)                                              				// loop forever
    {
    	__WFI();
    }
}
